new const NINTENDOMOD_KOOPATROOPA_PLUGIN[] = "Nintendo Mod X Koopa Troopa"
new const NINTENDOMOD_KOOPATROOPA_VERSION[] = "2.2"
new const NINTENDOMOD_KOOPATROOPA_AUTHOR[] = "Soloist/Mephisto"

/*
	1st Passive: Hard Back
		* Increased armor.
	2nd Passive: Mirror
		* Chance to do mirror damage.
	Skill 1: Mindless Wandering
		* Evade attacks just alittle bit more per level.
	Skill 2: Reinforcments
		* Chance to revive non Koopa Troopa on your team.
	Skill 3: Single Minded
		* Randomly respawn after death.
	PowerUp: Shell Slide
		* Hit the opponents deadly by sliding randomly around.

	Based on Soloist's original source code Koopa Troopa v1.1, updated by Mephisto
	Version 2.2
	Last Updated On 06/09/09

	*************************************************************************************

	Changelog
		Version 2.2
			* fixed Reinforcements bug
		Version 2.1
			* fixed missing HUD bug after respawn
		Version 2.0.2
			* fixed some description bugs
		Version 2.0.1
			* plugin title changed
		Version 2.0
			* speed boost for some seconds when Koopa revives himself
			* skills have four levels now, PowerUp has three levels
			* lvl cap increased to 15
			* 2nd passive skill added
		Version 1.3
			* Fixed Single Minded bug
		Version 1.2
			* Fixed Reinforcements bug
		Version 1.1
			* Fixed Reinforcements bug
			* Fixed Single Minded bug
		Version 1.0
			* Release of the plugin
*/

#include <amxmodx>
#include <cstrike>
#include <hamsandwich>
#include <fun>
#include <fakemeta>
#include <nintendomod>

new const Float:KOOPATROOPA_ARMORNUM[11] = {100.0, 110.0, 120.0, 130.0, 140.0, 150.0, 160.0, 170.0, 180.0, 190.0, 200.0};
new const Float:KOOPATROOPA_MIRRORPROB[5] = {0.06, 0.07, 0.08, 0.09, 0.10};
new const Float:KOOPATROOPA_MIRRORSTRENGTH[5] = {0.20, 0.25, 0.30, 0.35, 0.40};
new const Float:KOOPATROOPA_SHELLDURATION[3] = {5.0, 6.0, 7.0};
new const Float:KOOPATROOPA_SHELLSPEED[3] = {2000.0, 2250.0, 2500.0};
new const Float:KOOPATROOPA_MINDLESSPROB[4] = {0.25, 0.40, 0.50, 0.55};
new const Float:KOOPATROOPA_SINGLEMINDEDPROB[4] = {0.20, 0.50, 0.90, 1.0};
new const Float:KOOPATROOPA_REINFORCMENTSPROB[4] = {0.20, 0.50, 0.90, 1.0};
new const Float:KOOPATROOPA_SPEEDBOOSTNUM[4] = {300.0, 350.0, 400.0, 450.0};

new charName[] = "KoopaTroopa";
new passiveName[] = "Hard Back";
new passive2Name[] = "Mirror";
new skill1Name[] = "Mindless Wandering";
new skill2Name[] = "Reinforcements";
new skill3Name[] = "Single Minded";
new powerupName[] = "Shell Slide";
new initName[] = "KoopaTroopa_Init";
new keyDownName[] = "KoopaTroopa_ShellSlide";

new passiveHelp[] = "Increased armor.";
new passive2Help[] = "Chance to do mirror damage.";
new skill1Help[] = "Evade attacks just alittle bit more per level.";
new skill2Help[] = "Chance to revive non Koopa Troopa on your team.";
new skill3Help[] = "Chance to respawn yourself after death.";
new powerupHelp[] = "Hit the opponents deadly by sliding randomly around.";

new PlayerLevel[33];
new PlayerSkill1[33];
new PlayerSkill2[33];
new PlayerSkill3[33];
new PlayerPowerUp[33];

new bool:BetweenRounds, bool:boost[33];

new bool:PlayerReinforcmentsUsed[33], bool:PlayerSingleMindedUsed[33], bool:shellSlide[33];

public plugin_init()
{
	if(is_plugin_loaded("Nintendo Mod Xtended") == -1)
	{
		server_print("**********************************");
		server_print("*** Nintendo Mod is not loaded ***");
		server_print("**********************************");
		pause("ae");
		return;
	}

	register_plugin(NINTENDOMOD_KOOPATROOPA_PLUGIN, NINTENDOMOD_KOOPATROOPA_VERSION, NINTENDOMOD_KOOPATROOPA_AUTHOR);

	register_cvar("NintendoMod_KoopaTroopa_Version", NINTENDOMOD_KOOPATROOPA_VERSION, FCVAR_SERVER|FCVAR_SPONLY);

	register_event("ResetHUD", "ResetHUD", "b");
	register_logevent("RoundStart", 2, "1=Round_Start");
	register_logevent("RoundEnd", 2, "1=Round_End");

	RegisterHam(Ham_TakeDamage, "player", "KoopaTroopa_MindlessWandering");
	register_event("DeathMsg", "KoopaTroopa_DeathMsg", "ae");
	register_forward(FM_Touch, "KoopaTroopa_ShellSlideTouch");
	register_event("CurWeapon", "KoopaTroopa_Speed","be");

	Nintendo_RegisterChar(charName, passiveName, passive2Name, skill1Name, skill2Name, skill3Name, powerupName, initName);
	Nintendo_RegisterHelp(charName, passiveHelp, passive2Help, skill1Help, skill2Help, skill3Help, powerupHelp);
	Nintendo_RegisterKeyDown(charName, keyDownName);

	register_srvcmd(initName, initName);
	register_srvcmd(keyDownName, keyDownName);
}

public plugin_precache()
{
	engfunc(EngFunc_PrecacheSound, "nintendomod/koopa_speedboost.wav");
}

public client_connect(id)
{
	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	InitPlayer(id);

	return PLUGIN_CONTINUE;
}

public client_disconnect(id)
{
	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	InitPlayer(id);
	remove_task(id);

	return PLUGIN_CONTINUE;
}

public InitPlayer(id)
{
	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	PlayerLevel[id] = 0;
	PlayerSkill1[id] = 0;
	PlayerSkill2[id] = 0;
	PlayerSkill3[id] = 0;
	PlayerPowerUp[id] = 0;

	return PLUGIN_CONTINUE;
}

public KoopaTroopa_Init()
{
	new temp[33];
	read_argv(1, temp, 32);
	new id = str_to_num(temp);

	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	read_argv(2, temp, 32);
	new index  = str_to_num(temp);

	if(index == 0)
	{
		read_argv(3, temp, 32);
		new level = str_to_num(temp);
		read_argv(4, temp, 32);
		new skill1 = str_to_num(temp);
		read_argv(5, temp, 32);
		new skill2 = str_to_num(temp);
		read_argv(6, temp, 32);
		new skill3 = str_to_num(temp);
		read_argv(7, temp, 32);
		new powerup = str_to_num(temp);

		PlayerLevel[id] = level;
		PlayerSkill1[id] = skill1;
		PlayerSkill2[id] = skill2;
		PlayerSkill3[id] = skill3;
		PlayerPowerUp[id] = powerup;
	}
	else
	{
		read_argv(3, temp, 32);
		new value = str_to_num(temp);

		switch(index)
		{
			case 1: PlayerLevel[id] = value;
			case 2: PlayerSkill1[id] = value;
			case 3: PlayerSkill2[id] = value;
			case 4: PlayerSkill3[id] = value;
			case 5: PlayerPowerUp[id] = value;
		}
	}

	ResetHUD(id);

	return PLUGIN_CONTINUE;
}

public RoundStart()
{
	if(!Nintendo_Active())
		return PLUGIN_HANDLED;

	BetweenRounds = false;

	new players[32], num, player;
	get_players(players, num);
	for(new i = 0; i <= num; i++)
	{
		player = players[i];
		if(Nintendo_IsValidPlayer(player))
		{
			PlayerReinforcmentsUsed[player] = false;
			PlayerSingleMindedUsed[player] = false;
		}
	}

	return PLUGIN_CONTINUE;
}

public RoundEnd()
{
	if(!Nintendo_Active())
		return PLUGIN_HANDLED;

	BetweenRounds = true;

	return PLUGIN_CONTINUE;
}

public ResetHUD(id)
{
	if(!Nintendo_Active() || !Nintendo_HasChar(id, charName) || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	set_task(get_cvar_float("mp_freezetime"), "KoopaTroopa_Passive", id);
	boost[id] = false;

	return PLUGIN_CONTINUE;
}

public KoopaTroopa_Passive(id) // Passive
{
	if(!Nintendo_Active() || !Nintendo_HasChar(id, charName) || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	if (PlayerLevel[id] > 10)
		Nintendo_SetArmor(id, KOOPATROOPA_ARMORNUM[10]);
	else
		Nintendo_SetArmor(id, KOOPATROOPA_ARMORNUM[PlayerLevel[id]]);

	return PLUGIN_CONTINUE;
}

// id = victim, inflictor = weapon used
public KoopaTroopa_MindlessWandering(id, inflictor, attacker, Float:damage, damage_type) // Skill 1
{
	if (shellSlide[id] == true && attacker == 0)
		return HAM_SUPERCEDE;
	if(!Nintendo_Active() || !Nintendo_HasChar(id, charName) || !Nintendo_IsValidPlayer(id))
		return HAM_IGNORED;

	new attacker = get_user_attacker(id);

	if(PlayerLevel[id] > 10 && id != attacker)
	{
		if(!Nintendo_IsValidPlayer(attacker))
			return HAM_IGNORED;
		new Float:randomnumber = random_float(0.0, 1.0);
		if(Nintendo_TeamKill(id, attacker) && randomnumber <= KOOPATROOPA_MIRRORPROB[PlayerLevel[id] - 11])
		{
			new damage = floatround(read_data(2) * KOOPATROOPA_MIRRORSTRENGTH[PlayerLevel[id] - 11]);
			Nintendo_ExtraDamage(id, attacker, damage, "Mirror", 0);
		}
	}

	if(PlayerSkill1[id] > 0)
	{
		if(!Nintendo_IsValidPlayer(attacker))
			return HAM_IGNORED;

		if(attacker != id)
		{
			new Float:randomnumber = random_float(0.0, 1.0);
			if(randomnumber <= KOOPATROOPA_MINDLESSPROB[PlayerSkill1[id] - 1])
			{
				message_begin(MSG_ONE, get_user_msgid("ScreenFade"), {0,0,0}, id)
				write_short(1<<0);
				write_short(1<<10);
				write_short(1<<12);
				write_byte(255);
				write_byte(204);
				write_byte(51);
				write_byte(100);
				message_end();

				return HAM_SUPERCEDE;
			}
		}
	}

	return HAM_IGNORED;
}

public KoopaTroopa_DeathMsg() // Skill 2 and 3
{
	new id = read_data(2);
	if(!Nintendo_Active() || !is_user_connected(id))
		return PLUGIN_HANDLED;

	if(Nintendo_HasChar(id, charName) && PlayerSkill3[id] > 0)
	{
		if(!PlayerSingleMindedUsed[id])
		{
			new Float:randomnumber = random_float(0.0, 1.0);
			if(randomnumber <= KOOPATROOPA_SINGLEMINDEDPROB[PlayerSkill3[id] - 1])
				set_task(1.0, "KoopaTroopa_SingleMinded", id);
		}
	}
	else
	{
		new players[32], num, player;
		get_players(players, num);
		for(new i = 0; i <= num; i++)
		{
			player = players[i];
			if(!Nintendo_IsValidPlayer(player) || player == id || get_user_team(player) != get_user_team(id))
				continue;
			if(Nintendo_HasChar(player, charName) && !PlayerReinforcmentsUsed[player] && PlayerSkill2[player] > 0)
			{
				new Float:randomnumber = random_float(0.0, 1.0);
				if(randomnumber <= KOOPATROOPA_REINFORCMENTSPROB[PlayerSkill2[player] - 1])
				{
					PlayerReinforcmentsUsed[player] = true;
					new parm[2];
					parm[0] = id;
					parm[1] = player;
					set_task(1.0, "KoopaTroopa_Reinforcments", 0, parm, 2);
				}
			}
		}
	}
	return PLUGIN_CONTINUE;
}

public KoopaTroopa_Reinforcments(parm[]) // Skill 2
{
	new dead = parm[0];
	new player = parm[1];

	if(!Nintendo_Active() || !Nintendo_HasChar(player, charName) || !Nintendo_IsValidPlayer(player))
		return PLUGIN_HANDLED;

	if(PlayerSkill2[player] > 0)
	{
		if(!BetweenRounds)
		{
			new playername[33], tmp[54];
			get_user_name(player, playername, 32);
			format(tmp, 54, "[Koopa Troopa] You were respawned by %s", playername)
			Nintendo_StatusHUD(dead, tmp, 1);
			ExecuteHam(Ham_CS_RoundRespawn, dead);
			set_task(0.2, "KoopaTroopa_FinishSpawn", dead);
			set_task(0.4, "KoopaTroopa_GiveWeapons", dead);
		}
	}

	return PLUGIN_CONTINUE;
}

public KoopaTroopa_SingleMinded(id) // Skill 3
{
	if(PlayerSkill3[id] > 0)
	{
		if(!PlayerSingleMindedUsed[id])
		{
			Nintendo_StatusHUD(id, "[Koopa Troopa] You respawned yourself and received a speed boost for a short period of time", 1);
			PlayerSingleMindedUsed[id] = true;
			ExecuteHam(Ham_CS_RoundRespawn, id);
			set_task(0.2, "KoopaTroopa_FinishSpawn", id);
			set_task(0.4, "KoopaTroopa_SpeedBoost", id);
		}
	}

	return PLUGIN_CONTINUE;
}

public KoopaTroopa_FinishSpawn(id)
{
	Nintendo_GiveItem(id, "item_suit");
}

public KoopaTroopa_GiveWeapons(id)
{
	if(get_user_team(id) == 1)
		Nintendo_GiveItem(id, "weapon_glock");
	else if(get_user_team(id) == 2)
		Nintendo_GiveItem(id, "weapon_usp");
	Nintendo_GiveItem(id, "weapon_knife");
	
	return PLUGIN_CONTINUE;
}

public KoopaTroopa_Speed(id)
{
	if(!Nintendo_Active() || !Nintendo_HasChar(id, charName) || !Nintendo_IsValidPlayer(id) || PlayerSkill3[id] < 1)
		return PLUGIN_HANDLED;

	if(boost[id])
		Nintendo_SetSpeed(id, KOOPATROOPA_SPEEDBOOSTNUM[PlayerSkill3[id] - 1]);

	return PLUGIN_CONTINUE;
}

public KoopaTroopa_SpeedBoost(id)
{
	if(!Nintendo_Active() || !Nintendo_HasChar(id, charName) || !Nintendo_IsValidPlayer(id) || PlayerSkill3[id] < 1)
		return PLUGIN_HANDLED;

	KoopaTroopa_GiveWeapons(id);
	Nintendo_SetSpeed(id, KOOPATROOPA_SPEEDBOOSTNUM[PlayerSkill3[id] - 1]);
	boost[id] = true;
	emit_sound(id, CHAN_AUTO, "nintendomod/koopa_speedboost.wav", 1.0, ATTN_NORM, 0, PITCH_NORM);
	set_task(10.0, "KoopaTroopa_ResetBoost", id);

	return PLUGIN_CONTINUE;
}

public KoopaTroopa_ResetBoost(id)
{
	boost[id] = false;
	if(!Nintendo_Active() || !Nintendo_HasChar(id, charName) || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	Nintendo_SetSpeed(id);
	return PLUGIN_CONTINUE;
}

public KoopaTroopa_ShellSlide()
{
	new temp[6]
	read_argv(1, temp, 5)
	new id = str_to_num(temp)

	if(!Nintendo_Active() || !Nintendo_HasChar(id, charName) || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	if(PlayerPowerUp[id] >= 1)
	{
		Nintendo_PowerUpUsed(id, 1, 30);

		new Float:idVelocity[3];
		pev(id, pev_velocity, idVelocity);
		if(idVelocity[0] > 0) idVelocity[0] = KOOPATROOPA_SHELLSPEED[PlayerPowerUp[id] - 1];
		else if(idVelocity[0] < 0) idVelocity[0] = - KOOPATROOPA_SHELLSPEED[PlayerPowerUp[id] - 1];
		else idVelocity[0] = KOOPATROOPA_SHELLSPEED[PlayerPowerUp[id] - 1];

		if(idVelocity[1] > 0) idVelocity[1] = KOOPATROOPA_SHELLSPEED[PlayerPowerUp[id] - 1];
		else if(idVelocity[1] < 0) idVelocity[0] = - KOOPATROOPA_SHELLSPEED[PlayerPowerUp[id] - 1];
		else idVelocity[1] = KOOPATROOPA_SHELLSPEED[PlayerPowerUp[id] - 1];

		idVelocity[2] = 0.0;

		set_pev(id, pev_friction, 1.0);
		set_pev(id, pev_friction, 0.001)

		set_pev(id, pev_velocity, idVelocity);
		new parm[21];
		parm[0] = id;

		shellSlide[id] = true;

		Nintendo_StatusHUD(id, "Shell Slide On", 1);
		set_task(KOOPATROOPA_SHELLDURATION[PlayerPowerUp[id] - 1], "KoopaTroopa_ShellSlideReset", 0, parm, 1);
	}

	return PLUGIN_CONTINUE;
}

public KoopaTroopa_ShellSlideTouch(victim, attacker)
{
	if(!Nintendo_Active() || !Nintendo_HasChar(attacker, charName) || !Nintendo_IsValidPlayer(victim) || !Nintendo_IsValidPlayer(attacker))
		return PLUGIN_HANDLED;

	if(shellSlide[attacker])
	{
		if(Nintendo_TeamKill(victim, attacker))
			Nintendo_ExtraDamage(attacker, victim, 200, "Shell Slide", 0);
	}

	return PLUGIN_CONTINUE;
}

public KoopaTroopa_ShellSlideReset(parm[])
{
	new id = parm[0];
	if(!Nintendo_Active() || !Nintendo_HasChar(id, charName) || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	Nintendo_StatusHUD(id, "Shell Slide Off", 1);
	set_pev(id, pev_friction, 1.0);

	shellSlide[id] = false;

	return PLUGIN_CONTINUE;
}
